<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\View\Composers\AdminMenuComposer;
use App\Services\MenuManager;

class AdminMenuServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register()
    {
        $this->app->singleton(MenuManager::class, function ($app) {
            return new MenuManager();
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot()
    {
        // Register view composer for admin layout
        View::composer('layouts.admin', function ($view) {
            try {
                if (auth()->check()) {
                    $menuManager = app(MenuManager::class);
                    $categories = $menuManager->getCategories();
                    $pluginMenuItems = [];

                    // Get menu items for each category
                    foreach ($categories as $key => $category) {
                        $items = $menuManager->getCategoryItems($key);
                        
                        // Filter items based on user permissions
                        $accessibleItems = array_filter($items, function($item) use ($menuManager) {
                            return $menuManager->canAccessMenuItem($item);
                        });
                        
                        if (!empty($accessibleItems)) {
                            $pluginMenuItems[$key] = [
                                'category' => $category,
                                'items' => array_values($accessibleItems) // Re-index array
                            ];
                        }
                    }

                    $view->with('pluginMenuItems', $pluginMenuItems);
                }
            } catch (\Exception $e) {
                \Log::error('View composer error: ' . $e->getMessage());
                $view->with('pluginMenuItems', []);
            }
        });
    }
}